var functions = {
    url: '',
    getUrl: $(function () {
        var url = window.location.host.split(':');
        functions.url = (url[0] == 'localhost') ? '' : '/Portal';
    }),
    menuDropDown: $(function () {
        $('#content-wide').click(function () {
            $('li').removeClass('active');
            $('.hide-menu').css('display', 'none');
        });

        $('nav ul > li').click(function () {
            $('div.hide-menu').css('display', 'none');
            $('li').removeClass('active');
            $(this).find('div:first').toggle();
            $(this).addClass('active');
        });
    }),
    showMenuRsp: $(function () {
        $('a.menu-collapse').click(function (e) {
            $('nav').toggle();
            e.preventDefault();
        });
    }),
    scrollToTop: $(function () {
        $(window).scroll(function () {
            if ($(window).scrollTop() > 10) {
                $('footer #to-top').fadeIn(500);
            } else {
                $('footer #to-top').fadeOut(500);
            }
        });

        $('.to-top').click(function (e) {
            $("html, body").animate({ scrollTop: -10 }, "slow");
            e.preventDefault();
        });
    }),
    autoFocus: $(function () {
        $('[autofocus]:not(:focus)').eq(0).focus();
    }),
    setFocus: function (inputClass) {
        $(inputClass).focus();
    },
    dataGridControl: function (zebra, action) {
        if (zebra) {
            $('.data-grid table tr:even').addClass('zebra');
        }
        if (action) {
            $('.data-grid tr:gt(0)').click(function () {
                $('.data-grid tr').removeClass('active');
                $('.data-grid div').css('display', 'none');
                $(this).find('div:first').slideDown('fast');
                $(this).addClass('active');
            });
        }
        return true;
    },
    loadModal: function (link, page) {
        $(link).click(function () {
            var scrollTop = $(document).scrollTop();
            $('#modal-window').empty();
            $('#modal-overlay').css('display', 'block');
            $('#modal-window').load(page).css({ display: 'block', top: scrollTop });
            return false;
        });
        return true;
    },
    dynamicLoadModal: function (page) {
        var scrollTop = $(document).scrollTop();
        $('#modal-window').empty();
        $('#modal-overlay').css('display', 'block');
        $('#modal-window').load(page).css({ display: 'block', top: scrollTop });
    },
    closeModal: function (link, winClose) {
        $(link).click(function () {
            $('#modal-overlay,' + winClose).css('display', 'none');
            return false;
        });
        return true;
    },
    closeModalNoClick: function (winClose) {
        $('#modal-overlay,' + winClose).css('display', 'none');
        return false;
    },
    loadModalLoading: function () {
        $('#modal-loading').css('display', 'block');
    },
    closeModalLoading: function () {
        $('#modal-loading').css('display', 'none');
    },
    loadModalAlert: function (title, msg) {
        $('#alert-title').text(title);
        $('#alert-msg').html(msg);
        $('#modal-alert').css('display', 'block');
    },
    closeModalAlert: $(function () {
        $('#alert-content #header a').click(function () {
            $('#modal-alert').css('display', 'none');
            $('#Documento').focus();
        });
        $(document).keypress(function (e) {
            if (e.keyCode == 27) {
                $('#modal-alert').css('display', 'none');
                $('#Documento').focus();
            }
        });
    }),
    errorMessage: function () {
        $('.msg-error').css('display', 'block');
    },
    validateForm: function (form, toUpper) {
        $(form).submit(function () {
            var firstEmptyInput = '';
            $('.req, .opt').removeClass('empty');
            $(form + ' .req').map(function () {
                var object = $(this);
                if ($.trim(object.val()) === '') {
                    $(object).addClass('empty');
                    if (firstEmptyInput === '') {
                        firstEmptyInput = object;
                    }
                }
            });
            $('form .noaccent').map(function () {
                var input = functions.replaceAccent($(this).val(), toUpper);
                $(this).val(input);
            });
            if (firstEmptyInput !== '') {
                functions.requiredField(firstEmptyInput, 'Por favor, preencha os campos em destaque.')
                return false;
            }
        });
        return true;
    },
    // retira acentuo de inputs e parametro toUpper(true, false) converte para upperCase
    replaceAccent: function (input, toUpper) {
        input = input.replace(new RegExp('[]', 'gi'), 'a');
        input = input.replace(new RegExp('[]', 'gi'), 'e');
        input = input.replace(new RegExp('[]', 'gi'), 'i');
        input = input.replace(new RegExp('[]', 'gi'), 'o');
        input = input.replace(new RegExp('[]', 'gi'), 'u');
        input = input.replace(new RegExp('[]', 'gi'), 'c');
        input = input.replace(new RegExp('[\\"\'`~^]', 'gi'), '');

        return toUpper ? input.toUpperCase() : input;
    },
    requiredField: function (object, message) {
        object.addClass('empty');
        $('p.msg-error').text(message).css('display', 'block');
        $('html, body').animate({ scrollTop: $(object).offset().top - 20 }, 1000);
        object.focus();
    },
    maskInput: function () {
        $('.date').mask('99/99/9999', {
            placeholder: ' ', completed: function () {
                functions.jumpToNext();
            }
        });
        $('.dateMMAAAA').mask('99-9999', {
            placeholder: ' ', completed: function () {
                functions.jumpToNext();
            }
        });
        $('.cpf').mask('999.999.999-99', {
            placeholder: ' ', completed: function () {
                functions.jumpToNext();
            }
        });
        $('.cnpj').mask('99.999.999/9999-99', {
            placeholder: ' ', completed: function () {
                functions.jumpToNext();
            }
        });
        $('.cep').mask('99999-999', {
            placeholder: ' ', completed: function () {
                functions.jumpToNext();
            }
        });
        $('.ddd').mask('99', {
            placeholder: ' ', completed: function () {
                functions.jumpToNext();
            }
        });
        $('.uf').mask('aa', {
            completed: function () {
                functions.jumpToNext();
            }
        });
        $('.fone').mask('99999999?9', { placeholder: ' ' });
        $('.int4').mask('9?999', { placeholder: ' ' });
        $(".decimal").maskMoney({
            thousands: '.',
            decimal: ','
        });
    },
    jumpToNext: function () {
        $(":input")[$(":input").index(document.activeElement) + 1].focus();
    },
    validateEmail: function (email) {
        //var exclude = /[^@\-\.\w]|^[_@\.\-]|[\._\-]{3}|[@\.]{2}|(@)[^@]*\1/;
        var exclude = /[^@\-\.\w]|^[_@\.\-]|[@\.]{2}|(@)[^@]*\1/;
        var check = /@[\w\-]+\./;
        var checkend = /\.[a-zA-Z]{2,3}$/;
        if (((email.search(exclude) != -1) || (email.search(check)) == -1) || (email.search(checkend) == -1)) {
            return false;
        } else {
            return true;
        }
    },
    validateCpf: function (cpf) {
        var i;
        cpf = cpf.replace(".", "");
        cpf = cpf.replace(".", "");
        cpf = cpf.replace("-", "");
        if (cpf.length != 11 || cpf == "00000000000" || cpf == "11111111111" || cpf == "22222222222" || cpf == "33333333333" || cpf == "44444444444" || cpf == "55555555555" || cpf == "66666666666" || cpf == "77777777777" || cpf == "88888888888" || cpf == "99999999999") {
            return false;
        }
        var c = cpf.substr(0, 9);
        var dv = cpf.substr(9, 2);
        var d1 = 0;
        for (i = 0; i < 9; i++) {
            d1 += c.charAt(i) * (10 - i);
        }
        if (d1 == 0) {
            return false;
        }
        d1 = 11 - (d1 % 11);
        if (d1 > 9)
            d1 = 0;
        if (dv.charAt(0) != d1) {
            return false;
        }
        d1 *= 2;
        for (i = 0; i < 9; i++) {
            d1 += c.charAt(i) * (11 - i);
        }
        d1 = 11 - (d1 % 11);
        if (d1 > 9)
            d1 = 0;
        if (dv.charAt(1) != d1) {
            return false;
        }
        return true;
    },
    validateCnpj: function (cnpj) {
        cnpj = cnpj.replace(/[^\d]+/g, '');

        if (cnpj == '') return false;

        if (cnpj.length != 14)
            return false;

        // Elimina CNPJs invalidos conhecidos
        if (cnpj == "00000000000000" ||
            cnpj == "11111111111111" ||
            cnpj == "22222222222222" ||
            cnpj == "33333333333333" ||
            cnpj == "44444444444444" ||
            cnpj == "55555555555555" ||
            cnpj == "66666666666666" ||
            cnpj == "77777777777777" ||
            cnpj == "88888888888888" ||
            cnpj == "99999999999999")
            return false;

        // Valida DVs
        tamanho = cnpj.length - 2
        numeros = cnpj.substring(0, tamanho);
        digitos = cnpj.substring(tamanho);
        soma = 0;
        pos = tamanho - 7;
        for (i = tamanho; i >= 1; i--) {
            soma += numeros.charAt(tamanho - i) * pos--;
            if (pos < 2)
                pos = 9;
        }
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(0))
            return false;

        tamanho = tamanho + 1;
        numeros = cnpj.substring(0, tamanho);
        soma = 0;
        pos = tamanho - 7;
        for (i = tamanho; i >= 1; i--) {
            soma += numeros.charAt(tamanho - i) * pos--;
            if (pos < 2)
                pos = 9;
        }
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(1))
            return false;

        return true;
    },
    loadingPagination: function (idLoading, idPagination) {
        $('#' + idPagination).hide();
        $('#' + idLoading).html('Carregando...').addClass('msg-loading');
    },
    validateNumber: function (string) {
        $(string).keydown(function (e) {
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
                        (e.keyCode == 65 && e.ctrlKey === true) ||
                        (e.keyCode >= 35 && e.keyCode <= 39)) {
                return;
            }
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
            }
        });
    },
    maskDate: function () {
        $('.date').keydown(function (e) {
            var date = $(this);
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
                        (e.keyCode == 65 && e.ctrlKey === true) ||
                        (e.keyCode >= 35 && e.keyCode <= 39)) {
                return;
            }
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
            }
            if (date.val().length == 2 || date.val().length == 5) {
                $(this).val(date.val() + '/');
            }
        });
    },
    //incluir <div class="tip"></div> na pgina
    openTip: $(function () {
        $('body').on('click', '.open-tip', function () {
            var top = $(this).offset().top + 20;
            var left = $(this).offset().left;
            var dif = $(document).width() - left;
            left = (dif < 250) ? left + (dif - 250) : left;
            $('.tip')
                .text($(this).attr('rel'))
                .prepend('<a class="close-tip">')
                .slideDown()
                .css({ 'top': top, 'left': left })
            return false;
        });

        $('body').on('click', '.tip', function () {
            $('.tip').slideUp();
            return false;
        })
    }),
}